<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user is logged in
requireLogin();

header('Content-Type: application/json');

try {
    if (!isset($_GET['category_id']) || empty($_GET['category_id'])) {
        echo json_encode(['success' => false, 'error' => 'Category ID is required']);
        exit;
    }
    
    $category_id = intval($_GET['category_id']);
    
    // Fetch products from the selected category
    $stmt = $pdo->prepare("
        SELECT id, name, price, cost_price, quantity 
        FROM products 
        WHERE category_id = ? 
        ORDER BY name ASC
    ");
    $stmt->execute([$category_id]);
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'products' => $products
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Error fetching products: ' . $e->getMessage()
    ]);
}
?> 